/*
 * Decompiled with CFR 0.152.
 */
package com.intershop.support.app_sf_mycoupon_rest.capi.resource;

import com.google.inject.Inject;
import com.intershop.beehive.core.internal.opexpression.parser.ParseException;
import com.intershop.component.application.capi.ApplicationBO;
import com.intershop.component.application.capi.CurrentApplicationBOProvider;
import com.intershop.component.rest.capi.RestException;
import com.intershop.component.rest.capi.resource.AbstractRestResource;
import com.intershop.support.app_sf_mycoupon_rest.capi.resourceobject.MyCouponRO;
import com.intershop.support.component.mycoupon.capi.ApplicationBOMyCouponExtension;
import com.intershop.support.component.mycoupon.capi.MyCouponBO;
import com.intershop.support.component.mycoupon.capi.MyCouponBORepository;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(name="Experimental", description="&nbsp;")
@OpenAPIDefinition(extensions={@Extension(properties={@ExtensionProperty(name="x-apiID", value="promotion")})})
public class MyCouponResource
extends AbstractRestResource {
    private static final String MY_COUPON = "mycoupon";
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    private CurrentApplicationBOProvider currentApplicationBOProvider;

    public MyCouponResource() {
        this.setName(MY_COUPON);
    }

    @Operation(summary="Creates a coupon.")
    @POST
    @Produces(value={"application/json", "text/xml"})
    public Response generateMyCoupon(@QueryParam(value="email") String email) throws ParseException {
        this.logger.debug("debug msg -> " + ((Object)((Object)this)).getClass().toString());
        if (email == null || email.length() == 0) {
            throw new RestException().badRequest().message("Email is required to generate a coupon!").localizationKey("mycoupon.missing_email.error");
        }
        ApplicationBOMyCouponExtension applicationBOMyCouponExtension = (ApplicationBOMyCouponExtension)((ApplicationBO)this.currentApplicationBOProvider.get()).getExtension("MyCoupon");
        MyCouponBORepository myCouponBORepository = applicationBOMyCouponExtension.getMyCouponBORepository();
        MyCouponBO myCouponBO = myCouponBORepository.createMyCouponBOByEmail(email);
        if (myCouponBO == null || myCouponBO.getCode() == null) {
            throw new RestException().message("The Coupon code could not be generated!").localizationKey("mycoupon.generate_not_possible.error");
        }
        MyCouponRO myCouponRO = new MyCouponRO(myCouponBO);
        this.setCacheExpires(0L);
        return this.getResponseBuilder().entity((Object)myCouponRO).build();
    }

    public MyCouponResource getRequestSpecificCopy(ResourceContext rc) {
        MyCouponResource result = (MyCouponResource)super.getRequestSpecificCopy(rc);
        return result;
    }
}

