package com.intershop.support.app_sf_mycoupon_rest.capi.resource;

import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.inject.Inject;
import com.intershop.beehive.core.internal.opexpression.parser.ParseException;
import com.intershop.component.application.capi.CurrentApplicationBOProvider;
import com.intershop.component.rest.capi.RestException;
import com.intershop.component.rest.capi.openapi.OpenAPIConstants;
import com.intershop.component.rest.capi.resource.AbstractRestResource;
import com.intershop.component.rest.internal.RestFrameworkConstants;
import com.intershop.support.app_sf_mycoupon_rest.capi.resourceobject.MyCouponRO;
import com.intershop.support.component.mycoupon.capi.ApplicationBOMyCouponExtension;
import com.intershop.support.component.mycoupon.capi.MyCouponBO;
import com.intershop.support.component.mycoupon.capi.MyCouponBORepository;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.tags.Tag;

@Tag(name = "Experimental", description = "&nbsp;")
@OpenAPIDefinition(extensions = @Extension(
                properties = { @ExtensionProperty(name = OpenAPIConstants.API_ID, value = "promotion") }))
public class MyCouponResource extends AbstractRestResource
{
    private static final String MY_COUPON = "mycoupon";

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Inject
    private CurrentApplicationBOProvider currentApplicationBOProvider;

    public MyCouponResource()
    {
        super();
        setName(MY_COUPON);
    }

    /**
     * Returns for a given email a coupon.
     */
    @Operation(summary = "Creates a coupon.")
    @POST
    @Produces({ MediaType.APPLICATION_JSON, MediaType.TEXT_XML })
    public Response generateMyCoupon(@QueryParam("email") String email) throws ParseException
    {
        logger.debug("debug msg -> " + this.getClass().toString());
        // validate query parameter 'email'
        if (email == null || email.length() == 0)
        {
            throw new RestException().badRequest()
                            .message("Email is required to generate a coupon!")
                            .localizationKey("mycoupon.missing_email.error");
        }

        // get MyCouponBORepository to create a coupon
        ApplicationBOMyCouponExtension applicationBOMyCouponExtension = currentApplicationBOProvider.get()
                        .getExtension(ApplicationBOMyCouponExtension.EXTENSION_ID);
        MyCouponBORepository myCouponBORepository = applicationBOMyCouponExtension.getMyCouponBORepository();

        // create a coupon
        MyCouponBO myCouponBO = myCouponBORepository.createMyCouponBOByEmail(email);

        // validate the business object in case of error throw an exception
        if (myCouponBO == null || myCouponBO.getCode() == null)
        {
            throw new RestException().message("The Coupon code could not be generated!")
                            .localizationKey("mycoupon.generate_not_possible.error");
        }

        MyCouponRO myCouponRO = new MyCouponRO(myCouponBO);

        // make non-cacheable
        setCacheExpires(RestFrameworkConstants.CACHE_EXPIRY_NOCACHE);
        return getResponseBuilder().entity(myCouponRO)
                        .build();
    }
    
    @Override
    public MyCouponResource getRequestSpecificCopy(ResourceContext rc)
    {
        MyCouponResource result = (MyCouponResource)super.getRequestSpecificCopy(rc);
        return result;
    }
}